require( "quest/m3_maze1/convout.lua" );
require( "quest/m3_maze_shared/m3_maze_shared.lua" );
combine_speech_tables();

debugText = nil;

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:FaceNow(DIR.S);
		actor:SetWalkSpeed(flo_speed);
		actor:JumpToNamedPoint("flo");
		actor:SetScale(0.6);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		
		actor:StartProc(goto_new_maze_position);
		
		scene:SetCameraFollowActor(actor);
	end;
	
	on_arrive = function(flo, flo2)
		convproc("FLO", "quip_bigcorp_music");
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function goto_exit(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("flo");
	wait_walkto();
	
	goto_scene(flo, "m3_lobby");
end

exit_door_spec = 
{
	name = "EXIT_DOOR";
	halo = "exit_door";
	goto_fn = goto_exit;
	cursor = "cursor_arrow_n";
}

debugger = 
{
	name = "DEBUGGER";	
}

function increment_card_count()
	local key = inv_desc_card.key;
	
	game:SetString("inventory_fly_back_item", key);
	game:Set("inventory_fly_back_loc_X", scene:GetCursorPos().x);
	game:Set("inventory_fly_back_loc_Y", scene:GetCursorPos().y);

	game:ClearInvUsage();
	
	-- hide the item
	BAG_INV:ShowInventory(key, false);
	
	-- scroll so the item's SLOT is visible
	BAG_INV:PositionInventoryForVisibility(key);
	
	-- go straight there (don't wait)
	BAG_INV:JumpInventoryToTarget(key);
	
	-- do the work
	scene:Spawn(inventory_flyback_spec);
	coroutine.yield(RESUME.ON_SIGNAL);
	
	-- re-enable the item
	BAG_INV:ShowInventory(key, true);
	
	--delay(30); -- make it snappy!
	scene.INVENTORY_FLYBACK:Expire();
	delay(2);

	local card_count = game:Get( "card_count", card_count );
		
	if card_count < 0 then
		card_count = 1;
	end
	
	card_count = card_count  + 1;
	
	game:Set( "card_count", card_count );
	BAG_INV:SetInventoryOvertextFlags("card", kHAlignCenter + kVAlignTop);
	BAG_INV:SetInventoryOvertext("card", card_count .. " / 5" );
	
	if card_count == 5 then
		delay(30);
		spawn_activity_complete_text("activity_complete_text", "audio/sfx/complete_display.ogg");
		coroutine.yield(RESUME.ON_SIGNAL);
	end
end

cubicle1_anim_table = 
{
	"anim/barb/maze",
};

function get_closer(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_maze1_get_closer");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function talk_to_cubicle1(flo)
	flo:SetMode(MODE.CUTSCENE);
	--game:ClearInvUsage();
	hide_arrows();
	
	flo:WalkTo("cubicle1_walkto");
	wait_walkto();
	
	flo:Face(DIR.E);
	
	scene.BARB:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.BARB:PlayAnim("Idle");
	wait_anim(scene.BARB);
	
	scene.BARB:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.BARB:PlayAnim("DoStandE");
	
	if ( game:Get( "cubicle1_signed" ) ~= 1 ) then
		run_super_conversation(flo, "conv_cubicle1_sign");
		game:Set( "cubicle1_signed", 1 );
		sfx:PlaySFX("audio/sfx/big_card");
		
		increment_card_count();
	else
		run_super_conversation(flo, "conv_cubicle1_already_signed");
	end
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	show_arrows();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle1_spec = 
{
	name = "BARB";
	halo = "quest/objects/cubicle1";
	gfx = { anim = "anim/barb/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle1_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle1");
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cubicle1_speed);
		actor:FaceNow(DIR.E);
		actor:SetDepthValue( 2000 );
		actor.closeEnoughPos = { row = 5, col = 1 };
	end;
	
	on_arrive = function(flo, cubicle1)
		if game:Get( "cubicle1_signed") == 1 then
			convproc("FLO", "conv_cubicle1_no_interrupt");
		else
			convproc("FLO", "conv_cubicle1_give_card");
		end
	end;
	
	on_use_inv = function(item, flo, cubicle1)		
		if ( maze_position.row == cubicle1.closeEnoughPos.row and maze_position.col == cubicle1.closeEnoughPos.col ) then
			if ( item == "card" ) then
				flo:StartProc(talk_to_cubicle1);		
				return RESPONSE.INV_HANDLED;
			end
		else
			flo:StartProc(get_closer);		
		end
	end;
};

function talk_to_cubicle2(flo)
	flo:SetMode(MODE.CUTSCENE);
	--game:ClearInvUsage();
	hide_arrows();
	
	flo:WalkTo("cubicle2_walkto");
	wait_walkto();
	
	--flo:FaceActor(cubicle2);
	flo:Face(DIR.W);
	
	scene.ROSIE:LastingEmotion();
	scene.ROSIE:SetEmotion("look");
	
	scene.ROSIE:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.ROSIE:PlayAnim("ToTalkE");
	wait_anim(scene.ROSIE);
	
	scene.ROSIE:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.ROSIE:PlayAnim("DoStandE_look");
	
	if ( game:Get( "cubicle2_signed" ) ~= 1 ) then
		run_super_conversation(flo, "conv_cubicle2_sign");
		game:Set( "cubicle2_signed", 1 );
		sfx:PlaySFX("audio/sfx/big_card");
		
		increment_card_count();
	else
		run_super_conversation(flo, "conv_cubicle2_already_signed");
	end
	
	scene.ROSIE:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.ROSIE:PlayAnim("FromTalkE");
	wait_anim(scene.ROSIE);
	
	scene.ROSIE:QuickEmotion();
	scene.ROSIE:ClearEmotion();
	
	scene.ROSIE:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.ROSIE:PlayAnim("DoStandE");
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	show_arrows();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle2_spec = 
{
	name = "ROSIE";
	halo = "quest/objects/cubicle2";
	gfx = { anim = "anim/rosie/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle2_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle2");
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cubicle2_speed);
		actor:FaceNow(DIR.E);
		actor.closeEnoughPos = { row = 4, col = 3 };
	end;
	
	on_arrive = function(flo, cubicle2)
		if game:Get( "cubicle2_signed") == 1 then
			convproc("FLO", "conv_cubicle1_no_interrupt");
		else
			convproc("FLO", "conv_cubicle1_give_card");
		end
	end;
	
	on_use_inv = function(item, flo, cubicle2)		
		if ( maze_position.row == cubicle2.closeEnoughPos.row and maze_position.col == cubicle2.closeEnoughPos.col ) then
			if ( item == "card" ) then
				flo:StartProc(talk_to_cubicle2);
				return RESPONSE.INV_HANDLED;				
			end
		else
			flo:StartProc(get_closer);		
		end
	end;
};

function talk_to_cubicle3(flo)
	flo:SetMode(MODE.CUTSCENE);
	--game:ClearInvUsage();
	hide_arrows();
	
	flo:WalkTo("cubicle3_walkto");
	wait_walkto();
	
	flo:Face(DIR.E);
	
	scene.SEYMOUR:LastingEmotion();
	scene.SEYMOUR:SetEmotion("look");
	
	scene.SEYMOUR:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.SEYMOUR:PlayAnim("ToTalkW");
	wait_anim(scene.SEYMOUR);
	
	scene.SEYMOUR:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.SEYMOUR:PlayAnim("DoStandW_look");
	
	if ( game:Get( "cubicle3_signed" ) ~= 1 ) then
		run_super_conversation(flo, "conv_cubicle3_sign");
		game:Set( "cubicle3_signed", 1 );
		sfx:PlaySFX("audio/sfx/big_card");
		
		increment_card_count();
	else
		run_super_conversation(flo, "conv_cubicle3_already_signed");
	end
	
	scene.SEYMOUR:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.SEYMOUR:PlayAnim("FromTalkW");
	wait_anim(scene.SEYMOUR);
	
	scene.SEYMOUR:QuickEmotion();
	scene.SEYMOUR:ClearEmotion();
	
	scene.SEYMOUR:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.SEYMOUR:PlayAnim("DoStandW");
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	show_arrows();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle3_spec = 
{
	name = "SEYMOUR";
	halo = "quest/objects/cubicle3";
	gfx = { anim = "anim/seymour/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle3_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle3");
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cubicle3_speed);
		actor:FaceNow(DIR.W);
		actor.closeEnoughPos = { row = 2, col = 2 };
	end;
	
	on_arrive = function(flo, cubicle3)
		if game:Get( "cubicle3_signed") == 1 then
			convproc("FLO", "conv_cubicle1_no_interrupt");
		else
			convproc("FLO", "conv_cubicle1_give_card");
		end
	end;
	
	on_use_inv = function(item, flo, cubicle3)		
		if ( maze_position.row == cubicle3.closeEnoughPos.row and maze_position.col == cubicle3.closeEnoughPos.col ) then
			if ( item == "card" ) then
				flo:StartProc(talk_to_cubicle3);	
				return RESPONSE.INV_HANDLED;				
			end
		else
			flo:StartProc(get_closer);			
		end
	end;
};

function talk_to_cubicle4(flo)
	flo:SetMode(MODE.CUTSCENE);
	--game:ClearInvUsage();
	hide_arrows();
	
	flo:WalkTo("cubicle4_walkto");
	wait_walkto();
	
	flo:Face(DIR.W);
	
	scene.NORBERT:LastingEmotion();
	scene.NORBERT:SetEmotion("talk");
	
	scene.NORBERT:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.NORBERT:PlayAnim("ToTalkE");
	wait_anim(scene.NORBERT);
	
	scene.NORBERT:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.NORBERT:PlayAnim("DoStandE_talk");
	
	if ( game:Get( "cubicle4_signed" ) ~= 1 ) then
		run_super_conversation(flo, "conv_cubicle4_sign");
		game:Set( "cubicle4_signed", 1 );
		sfx:PlaySFX("audio/sfx/big_card");
		
		increment_card_count();
	else
		run_super_conversation(flo, "conv_cubicle4_already_signed");
	end
	
	scene.NORBERT:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.NORBERT:PlayAnim("FromTalkE");
	wait_anim(scene.NORBERT);
	
	scene.NORBERT:QuickEmotion();
	scene.NORBERT:ClearEmotion();
	
	scene.NORBERT:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.NORBERT:PlayAnim("DoStandE");
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	show_arrows();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle4_spec = 
{
	name = "NORBERT";
	halo = "quest/objects/cubicle4";
	gfx = { anim = "anim/norbert/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle4_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle4");
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(cubicle4_speed);
		actor:FaceNow(DIR.E);
		actor:SetScale(0.7);
		actor.closeEnoughPos = { row = 2, col = 4 };
	end;
	
	on_arrive = function(flo, cubicle4)
		if game:Get( "cubicle4_signed") == 1 then
			convproc("FLO", "conv_cubicle1_no_interrupt");
		else
			convproc("FLO", "conv_cubicle1_give_card");
		end
	end;
	
	on_use_inv = function(item, flo, cubicle4)		
		if ( maze_position.row == cubicle4.closeEnoughPos.row and maze_position.col == cubicle4.closeEnoughPos.col ) then
			if ( item == "card" ) then
				flo:StartProc(talk_to_cubicle4);	
				return RESPONSE.INV_HANDLED;
			end
		else
			flo:StartProc(get_closer);		
		end
	end;
};

cubicle5_anim_table = 
{
	"anim/cubicle5/stand",
	"anim/cubicle5/talkw",
};

function talk_to_cubicle5(flo)
	flo:SetMode(MODE.CUTSCENE);
	--game:ClearInvUsage();
	hide_arrows();
	
	flo:WalkTo("cubicle5_walkto");
	wait_walkto();
	
	flo:Face(DIR.E);
	
	--scene.ROSIE2:LastingEmotion();
	--scene.ROSIE2:SetEmotion("look");
	
	--scene.ROSIE2:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	--scene.ROSIE2:PlayAnim("ToTalkE");
	--wait_anim(scene.ROSIE2);
	
	--scene.ROSIE2:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	--scene.ROSIE2:PlayAnim("DoStandE_look");
	
	if ( game:Get( "cubicle5_signed" ) ~= 1 ) then
		run_super_conversation(flo, "conv_cubicle5_sign");
		game:Set( "cubicle5_signed", 1 );
		sfx:PlaySFX("audio/sfx/big_card");
		
		increment_card_count();
	else
		run_super_conversation(flo, "conv_cubicle5_already_signed");
	end
	
	--scene.ROSIE2:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	--scene.ROSIE2:PlayAnim("FromTalkE");
	--wait_anim(scene.ROSIE2);
	
	--scene.ROSIE2:QuickEmotion();
	--scene.ROSIE2:ClearEmotion();
	
	--scene.ROSIE2:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	--scene.ROSIE2:PlayAnim("DoStandE");
		
	local label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	flo:WalkTo(label);
	wait_walkto();
	
	flo:Face(DIR.SE);
	show_arrows();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

cubicle5_spec = 
{
	name = "ROSIE2";
	halo = "quest/objects/cubicle5";
	gfx = { anim = "anim/chloe/maze" };
	
	command = function(actor)
		prepare_actor_text(actor, cubicle5_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("cubicle5");
		actor:FaceNow(DIR.W);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetDepthValue( 2000 );
		actor:SetWalkSpeed(cubicle5_speed);
		actor.closeEnoughPos = { row = 5, col = 7 };
	end;
	
	on_arrive = function(flo, cubicle5)
		if game:Get( "cubicle5_signed") == 1 then
			convproc("FLO", "conv_cubicle1_no_interrupt");
		else
			convproc("FLO", "conv_cubicle1_give_card");
		end
	end;
	
	on_use_inv = function(item, flo, cubicle5)		
		if ( maze_position.row == cubicle5.closeEnoughPos.row and maze_position.col == cubicle5.closeEnoughPos.col ) then
			if ( item == "card" ) then
				flo:StartProc(talk_to_cubicle5);
				return RESPONSE.INV_HANDLED;
			end
		else
			flo:StartProc(get_closer);		
		end
	end;
};

function dist( p1, p2 )
	local p3 = { x = p2.x - p1.x, y = p2.y - p1.y };	
	return math.sqrt( p3.x * p3.x + p3.y * p3.y );
end

maze_fax_spec = 
{
	name = "MAZE_FAX";
	halo = "maze_fax";
	
	command = function(actor)
		actor:SetDepthValue(5);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(
			function(flo)
				flo:SetMode(MODE.CUTSCENE);
				sfx:PlaySFX("audio/sfx/big_fax");
				delay(20);
				run_super_conversation(flo, "quip_maze_fax");
				flo:SetMode(MODE.FOLLOWCLICKS);
			end
		);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_big_corp.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		scene:SetFadeTarget { a = 1, r = 0, g = 0, b = 0 };
		scene:SetFadeColor { a = 1, r = 0, g = 0, b = 0 };
		
		spawn_load_bar("MAZE_LOAD", "text_maze_load", 9);
		
		coroutine.yield(RESUME.ON_DELAY);
		
		if IsCheatMode() then
			-- testing data
			--BAG_INV:AddInventory(inv_desc_card);
		end
		
		scene:LoadAtlas("quest/m3_maze_shared/pieces1"); -- load pieces
		scene:LoadAtlas("quest/m3_maze_shared/arrows"); -- load arrows
		scene:LoadAtlas("pieces2");
		scene:LoadAtlas("pieces3");
		
		update_load_bar("MAZE_LOAD", 1);
		
		spawn_simple_hotspot("maze_plant", 5);
		spawn_simple_hotspot("maze_cooler", 5);
		spawn_simple_hotspot("maze_file", 5);
		--spawn_simple_hotspot("maze_donuts", 5, 3);
		spawn_simple_hotspot("maze_recycle", 5);
		spawn_simple_hotspot("maze_poster1", 5);
		spawn_simple_hotspot("maze_poster2", 5);
		spawn_simple_hotspot("maze_calendar", 5);
		spawn_nav_arrow(exit_door_spec);
		
		update_load_bar("MAZE_LOAD", 2);
		
		spawn_bg_actor("maze1_exit1", 100 );
		spawn_bg_actor( "maze1_row1a", 400 );
		spawn_bg_actor( "maze1_row1b", 290 );
		spawn_bg_actor( "maze1_row1c", 400 );
		spawn_bg_actor( "maze1_row1d", 400 );
		spawn_bg_actor( "maze1_row1e", 400 );
		spawn_bg_actor( "maze1_row1f", 290 );
		spawn_bg_actor( "maze1_row1g", 400 );
		spawn_bg_actor( "maze1_row1h", 255 );
		spawn_bg_actor( "maze1_row1i", 254 );
		spawn_bg_actor( "chair_mask_1", 410 );
		
		update_load_bar("MAZE_LOAD", 3);
		
		--spawn_bg_actor( "character_norbert", 490 );
		spawn_bg_actor( "maze1_row2a", 680 );
		spawn_bg_actor( "maze1_row2b", 480 );
		spawn_bg_actor( "maze1_row2c", 679 );
		spawn_bg_actor( "maze1_row2d", 678 );
		spawn_bg_actor( "maze1_row2e", 477 );
		spawn_bg_actor( "maze1_row2f", 676 );
		spawn_bg_actor( "maze1_row2g", 675 );
		spawn_bg_actor( "maze1_row2h", 674 );
		spawn_bg_actor( "maze1_row2i", 673 );
		
		update_load_bar("MAZE_LOAD", 4);
		
		--spawn_bg_actor( "character_rosie", 812 );
		spawn_bg_actor( "maze1_row3a", 935 );
		spawn_bg_actor( "maze1_row3b", 734 );
		spawn_bg_actor( "maze1_row3c", 933 );
		spawn_bg_actor( "maze1_row3d", 932 );
		spawn_bg_actor( "maze1_row3e", 931 );
		spawn_bg_actor( "maze1_row3f", 735 );
		spawn_bg_actor( "maze1_row3g", 930 );
		spawn_bg_actor( "maze1_row3h", 929 );
		spawn_bg_actor( "maze1_row3i", 928 );
		
		update_load_bar("MAZE_LOAD", 5);
		
		--spawn_bg_actor( "character_loretta", 1025 );
		spawn_bg_actor( "maze1_row4a", 1215 );
		spawn_bg_actor( "maze1_row4b", 1214 );
		spawn_bg_actor( "maze1_row4c", 1213 );
		spawn_bg_actor( "maze1_row4d", 1212 );
		spawn_bg_actor( "maze1_row4e", 1211 );
		spawn_bg_actor( "maze1_row4f", 1210 );
		spawn_bg_actor( "maze1_row4g", 1209 );
		spawn_bg_actor( "maze1_row4h", 1208 );
		spawn_bg_actor( "maze1_row4i", 1207 );
		
		update_load_bar("MAZE_LOAD", 6);
		
		--spawn_bg_actor( "character_joe", 1275 );
		--spawn_bg_actor( "character_chloe", 1280 );
		spawn_bg_actor( "maze1_row5a", 1560 );
		spawn_bg_actor( "maze1_row5b", 1559 );
		spawn_bg_actor( "maze1_row5c", 1558 );
		spawn_bg_actor( "maze1_row5d", 1557 );
		spawn_bg_actor( "maze1_row5e", 1556 );
		spawn_bg_actor( "maze1_row5f", 1555 );
		spawn_bg_actor( "maze1_row5g", 1554 );
		spawn_bg_actor( "maze1_row5h", 1553 );
		
		update_load_bar("MAZE_LOAD", 7);
		
		spawn_bg_actor( "maze1_furniture01", 250 );
		spawn_bg_actor( "maze1_furniture02", 450 );
		spawn_bg_actor( "maze1_furniture03", 150 );
		spawn_bg_actor( "maze1_furniture04", 295 );
		spawn_bg_actor( "maze1_furniture05", 240 );
		spawn_bg_actor( "maze1_furniture06", 260 );
		spawn_bg_actor( "maze1_furniture07", 620 );
		spawn_bg_actor( "maze1_furniture08", 560 );
		spawn_bg_actor( "maze1_furniture09", 440 );
		spawn_bg_actor( "maze1_furniture10", 680 );
		spawn_bg_actor( "maze1_furniture11", 475 );
		spawn_bg_actor( "maze1_furniture12", 680 );
		spawn_bg_actor( "maze1_furniture13", 840 );
		spawn_bg_actor( "maze1_furniture14", 840 );
		spawn_bg_actor( "maze1_furniture15", 1030 );
		spawn_bg_actor( "maze1_furniture16", 1060 );
		spawn_bg_actor( "maze1_furniture17", 1020 );
		spawn_bg_actor( "maze1_furniture18", 1300 );
		spawn_bg_actor( "maze1_furniture19", 1430 );
		spawn_bg_actor( "maze1_furniture20", 1530 );

		update_load_bar("MAZE_LOAD", 8);
		
		scene:Spawn(cubicle1_spec);
		scene:Spawn(cubicle2_spec);
		scene:Spawn(cubicle3_spec);
		scene:Spawn(cubicle4_spec);
		scene:Spawn(cubicle5_spec);
		scene:Spawn(maze_fax_spec);
		
		scene:Spawn(flo_spec);
		
		update_load_bar("MAZE_LOAD", 9);
		
		kill_load_bar("MAZE_LOAD");
		
		fade_scene_up();
	end;
};



scene_spec =
{
	atlas = 
	{
	--[[
		"quest/m3_maze_shared/arrows", -- load arrows
		"quest/m3_maze_shared/pieces1", -- load pieces
		"pieces2",
		"pieces3",
	--]]
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		--[[
		{"maze1_exit1", 100 },
		{ "maze1_row1a", 400 },
		{ "maze1_row1b", 290 },
		{ "maze1_row1c", 400 },
		{ "maze1_row1d", 400 },
		{ "maze1_row1e", 400 },
		{ "maze1_row1f", 290 },
		{ "maze1_row1g", 400 },
		{ "maze1_row1h", 255 },
		{ "maze1_row1i", 254 },
		{ "chair_mask_1", 410 },
		--{ "character_norbert", 490 },
		{ "maze1_row2a", 680 },
		{ "maze1_row2b", 480 },
		{ "maze1_row2c", 679 },
		{ "maze1_row2d", 678 },
		{ "maze1_row2e", 477 },
		{ "maze1_row2f", 676 },
		{ "maze1_row2g", 675 },
		{ "maze1_row2h", 674 },
		{ "maze1_row2i", 673 },
		--{ "character_rosie", 812 },
		{ "maze1_row3a", 935 },
		{ "maze1_row3b", 734 },
		{ "maze1_row3c", 933 },
		{ "maze1_row3d", 932 },
		{ "maze1_row3e", 931 },
		{ "maze1_row3f", 735 },
		{ "maze1_row3g", 930 },
		{ "maze1_row3h", 929 },
		{ "maze1_row3i", 928 },
		--{ "character_loretta", 1025 },
		{ "maze1_row4a", 1215 },
		{ "maze1_row4b", 1214 },
		{ "maze1_row4c", 1213 },
		{ "maze1_row4d", 1212 },
		{ "maze1_row4e", 1211 },
		{ "maze1_row4f", 1210 },
		{ "maze1_row4g", 1209 },
		{ "maze1_row4h", 1208 },
		{ "maze1_row4i", 1207 },
		--{ "character_joe", 1275 },
		--{ "character_chloe", 1280 },
		{ "maze1_row5a", 1560 },
		{ "maze1_row5b", 1559 },
		{ "maze1_row5c", 1558 },
		{ "maze1_row5d", 1557 },
		{ "maze1_row5e", 1556 },
		{ "maze1_row5f", 1555 },
		{ "maze1_row5g", 1554 },
		{ "maze1_row5h", 1553 },
		
		{ "maze1_furniture01", 250 },
		{ "maze1_furniture02", 450 },
		{ "maze1_furniture03", 150 },
		{ "maze1_furniture04", 295 },
		{ "maze1_furniture05", 240 },
		{ "maze1_furniture06", 260 },
		{ "maze1_furniture07", 620 },
		{ "maze1_furniture08", 560 },
		{ "maze1_furniture09", 440 },
		{ "maze1_furniture10", 680 },
		{ "maze1_furniture11", 475 },
		{ "maze1_furniture12", 680 },
		{ "maze1_furniture13", 840 },
		{ "maze1_furniture14", 840 },
		{ "maze1_furniture15", 1030 },
		{ "maze1_furniture16", 1060 },
		{ "maze1_furniture17", 1020 },
		{ "maze1_furniture18", 1300 },
		{ "maze1_furniture19", 1430 },
		{ "maze1_furniture20", 1530 },
		--]]
		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		scene_setup,
	};
};
